/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class CircleFunction
extends GeometryFunction {
    private ADQLOperand coord1;
    private ADQLOperand coord2;
    private ADQLOperand radius;

    public CircleFunction(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3, ADQLOperand aDQLOperand4) throws NullPointerException, Exception {
        super(aDQLOperand);
        if (aDQLOperand2 == null || aDQLOperand3 == null || aDQLOperand4 == null) {
            throw new NullPointerException("All parameters of a CIRCLE function must be different from NULL !");
        }
        this.coord1 = aDQLOperand2;
        this.coord2 = aDQLOperand3;
        this.radius = aDQLOperand4;
    }

    public CircleFunction(CircleFunction circleFunction) throws Exception {
        super(circleFunction);
        this.coord1 = (ADQLOperand)circleFunction.coord1.getCopy();
        this.coord2 = (ADQLOperand)circleFunction.coord2.getCopy();
        this.radius = (ADQLOperand)circleFunction.radius.getCopy();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new CircleFunction(this);
    }

    @Override
    public String getName() {
        return "CIRCLE";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public final void setCoord1(ADQLOperand aDQLOperand) {
        this.coord1 = aDQLOperand;
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public final void setCoord2(ADQLOperand aDQLOperand) {
        this.coord2 = aDQLOperand;
    }

    public final ADQLOperand getRadius() {
        return this.radius;
    }

    public final void setRadius(ADQLOperand aDQLOperand) {
        this.radius = aDQLOperand;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2, this.radius};
    }

    @Override
    public int getNbParameters() {
        return 4;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.coordSys;
            }
            case 1: {
                return this.coord1;
            }
            case 2: {
                return this.coord2;
            }
            case 3: {
                return this.radius;
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove one parameter of a " + this.getName() + " function !");
        }
        ADQLOperand aDQLOperand2 = null;
        switch (n) {
            case 0: {
                aDQLOperand2 = this.coordSys;
                this.setCoordinateSystem(aDQLOperand);
                break;
            }
            case 1: {
                aDQLOperand2 = this.coord1;
                this.coord1 = aDQLOperand;
                break;
            }
            case 2: {
                aDQLOperand2 = this.coord2;
                this.coord2 = aDQLOperand;
                break;
            }
            case 3: {
                aDQLOperand2 = this.radius;
                this.radius = aDQLOperand;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        return aDQLOperand2;
    }
}

